{include file="mheader.tpl"}
<!-- panel-wrapper -->
<main id="panel-wrapper">
    <!-- sidebar -->
    <section id="afix" class="left-sidebar">
        <div onclick="CoHeaderMenu('.left-sidebar')" class="close-menu float-right">
        </div>
        <div class="sidebar">
            <div class="header d-block d-md-none">
                <img src="styles/img/logo/logo.svg" height="30" width="100">
                <div class="title">
                    Dashboard
                </div>
            </div>
            <div class="user-info d-flex bw-flex-center">
                <svg class="avatar">
                    <svg xmlns="http://www.w3.org/2000/svg" viewbox="0 0 45.52 45.52" id="user2" width="100%" height="100%">
                        <g clip-path="url(#a)">
                            <path d="M22.83 21.36a6 6 0 1 1 6-6 6 6 0 0 1-6 6zm0-10.57a4.54 4.54 0 1 0 4.54 4.53 4.54 4.54 0 0 0-4.54-4.53z"></path>
                            <path d="M22.76 45.52a22.76 22.76 0 1 1 22.76-22.76 22.79 22.79 0 0 1-22.76 22.76zm0-44A21.26 21.26 0 1 0 44 22.76 21.28 21.28 0 0 0 22.76 1.5z"></path>
                            <path d="M28.43 37.07H17.71a4.56 4.56 0 0 1-3.86-7l2.8-4.43a7.59 7.59 0 0 1 12.84 0l2.8 4.43a4.56 4.56 0 0 1-3.86 7zM17.92 26.44l-2.8 4.43a3.06 3.06 0 0 0 2.59 4.7h10.72a3.06 3.06 0 0 0 2.57-4.7l-2.8-4.43a6.09 6.09 0 0 0-10.3 0z"></path>
                        </g>
                    </svg>
                </svg>
                <div class="info">
                    <h4 class="welcome">hi, {$userinfo.username}</h4>
                    <p class="email">
                        {$userinfo.email}
                    </p>
                </div>
            </div>
            <div class="clearfix">
            </div>
            <div class="menu mt-4">
                <ul>
                    <li>
                        <a href="?a=account"><span class="icon">
                                <svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewbox="0 0 14.4 15.17" id="dashboard" width="100%" height="100%">
                                        <g clip-path="url(#a)">
                                            <path d="M1 15.17a1 1 0 0 1-1-1V1a1 1 0 1 1 2 0v13.17a1 1 0 0 1-1 1zm6.2 0a1 1 0 0 1-1-1v-10a1 1 0 0 1 2 0v10a1 1 0 0 1-1 1zm6.2 0a1 1 0 0 1-1-1V7.76a1 1 0 1 1 2 0v6.41a1 1 0 0 1-1 1z"></path>
                                        </g>
                                    </svg>
                                </svg>
                            </span>
                            <span class="title">Dashboard</span>
                        </a>
                    </li>
                    <li>
                        <a href="?a=deposit"><span class="icon">
                                <svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewbox="0 0 19.83 17.03" id="wallet" width="100%" height="100%">
                                        <g clip-path="url(#a)">
                                            <path d="M14.28 17H3.71A3.71 3.71 0 0 1 0 13.32V5.89a2.3 2.3 0 0 1 2.3-2.3h13.39A2.3 2.3 0 0 1 18 5.89v2.29h-2V5.89a.3.3 0 0 0-.3-.3H2.3a.3.3 0 0 0-.3.3v7.43A1.71 1.71 0 0 0 3.71 15h10.57A1.71 1.71 0 0 0 16 13.32v-1h2v1A3.71 3.71 0 0 1 14.28 17z"></path>
                                            <path d="M17 13.1h-3.46a2.86 2.86 0 1 1 0-5.72H17a2.86 2.86 0 1 1 0 5.72zm-3.46-3.72a.86.86 0 1 0 0 1.72H17a.86.86 0 1 0 0-1.72zM2 5.72H0V4a4 4 0 0 1 4-4h8a2 2 0 0 1 2 2v3.5h-2V2H4a2 2 0 0 0-2 2z"></path>
                                        </g>
                                    </svg>
                                </svg>
                            </span>
                            <span class="title">Make Investment</span>
                        </a>
                    </li>
                    <li>
                        <a href="?a=deposit_list"><span class="icon">
                                <svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewbox="0 0 18.98 17.69" id="deposit-list" width="100%" height="100%">
                                        <g clip-path="url(#a)">
                                            <path d="M14.37 17.69H4.6a4.61 4.61 0 0 1-4.6-4.6V2.2A2.2 2.2 0 0 1 2.2 0h14.57A2.2 2.2 0 0 1 19 2.2v10.89a4.61 4.61 0 0 1-4.63 4.6zM2.2 2a.2.2 0 0 0-.2.2v10.89a2.6 2.6 0 0 0 2.6 2.6h9.77a2.6 2.6 0 0 0 2.6-2.6V2.2a.2.2 0 0 0-.2-.2z"></path>
                                            <path d="M4.89 5.1h9.4v2h-9.4zm0 4.65h9.4v2h-9.4z"></path>
                                        </g>
                                    </svg>
                                </svg>
                            </span>
                            <span class="title">Fund Management</span>
                        </a>
                    </li>
                    <li>
                        <a href="?a=withdraw"><span class="icon">
                                <svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewbox="0 0 18.34 19.78" id="withdraw" width="100%" height="100%">
                                        <g clip-path="url(#a)">
                                            <path d="M14.48 14.47a1 1 0 0 1 0-2 1.85 1.85 0 0 0 1.85-1.85v-8.1a.52.52 0 0 0-.51-.52H2.52a.52.52 0 0 0-.52.52v8.1a1.85 1.85 0 0 0 1.85 1.85 1 1 0 0 1 0 2A3.86 3.86 0 0 1 0 10.62v-8.1A2.52 2.52 0 0 1 2.52 0h13.3a2.52 2.52 0 0 1 2.52 2.52v8.1a3.86 3.86 0 0 1-3.86 3.85z"></path>
                                            <path d="M.84 3.74h16.5v2H.84zm8.25 13.55a1 1 0 0 1-1-1V9.52a1 1 0 1 1 2 0v6.77a1 1 0 0 1-1 1z"></path>
                                            <path d="M9.09 19.78a1 1 0 0 1-.71-.31l-3-3.18a1.001 1.001 0 0 1 1.46-1.37l2.3 2.44 2.48-2.46A1 1 0 1 1 13 16.31l-3.21 3.18a1 1 0 0 1-.7.29z"></path>
                                        </g>
                                    </svg>
                                </svg>
                            </span>
                            <span class="title">Withdraw</span>
                        </a>
                    </li>
                    <li>
                        <a href="?a=deposit_history"><span class="icon">
                                <svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewbox="0 0 18.84 19.74" id="transaction" width="100%" height="100%">
                                        <g clip-path="url(#a)">
                                            <path d="M15.35 5.21H8.58a1 1 0 0 1 0-2h6.77a1 1 0 0 1 0 2z"></path>
                                            <path d="M14.65 8.21A1 1 0 0 1 14 6.49l2.44-2.3-2.5-2.49A1 1 0 1 1 15.36.3l3.18 3.21a1 1 0 0 1 0 1.43l-3.18 3a1 1 0 0 1-.71.27zm-4.39 8.53H3.49a1 1 0 0 1 0-2h6.77a1 1 0 1 1 0 2z"></path>
                                            <path d="M4.18 19.74a1 1 0 0 1-.69-.27l-3.18-3A1 1 0 0 1 .29 15l3.18-3.21a1 1 0 0 1 1.42 1.41l-2.46 2.51L4.87 18a1 1 0 0 1-.69 1.73zm5.35-6.59a3.08 3.08 0 1 1 3.08-3.08 3.08 3.08 0 0 1-3.08 3.08zm0-4.15a1.08 1.08 0 1 0 1.08 1.08A1.08 1.08 0 0 0 9.53 9z"></path>
                                        </g>
                                    </svg>
                                </svg>
                            </span>
                            <span class="title">History</span>
                        </a>
                    </li>
                    <li>
                        <a href="?a=referals"><span class="icon">
                                <svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewbox="0 0 20.52 17.53" id="referrals" width="100%" height="100%">
                                        <g clip-path="url(#a)">
                                            <path d="M7.49 14.41H4.6A4.61 4.61 0 0 1 0 9.81V8.12a4.61 4.61 0 0 1 4.6-4.6h2.89a1 1 0 0 1 1 1v8.89a1 1 0 0 1-1 1zM4.6 5.52A2.6 2.6 0 0 0 2 8.12v1.69a2.6 2.6 0 0 0 2.6 2.6h1.89V5.52z"></path>
                                            <path d="M18.31 17.52a2.2 2.2 0 0 1-.74-.13L7.2 14.21a1 1 0 0 1-.71-1V4.52a1 1 0 0 1 .69-.95L17.55.14a2.16 2.16 0 0 1 2 .24 2.2 2.2 0 0 1 1 1.82v13.12a2.2 2.2 0 0 1-2.2 2.2zm-9.83-5l9.69 3h.06a.2.2 0 0 0 .27-.19V2.2a.19.19 0 0 0-.07-.2.19.19 0 0 0-.19 0L8.49 5.24z"></path>
                                        </g>
                                    </svg>
                                </svg>
                            </span>
                            <span class="title">Referrals</span>
                        </a>
                    </li>
                    <li>
                        <a href="?a=cust&amp;page=marketing_banners"><span class="icon">
                                <svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" id="marketing" viewbox="0 -14 512.00001 512" width="100%" height="100%">
                                        <path d="m136.964844 308.234375c4.78125-2.757813 6.417968-8.878906 3.660156-13.660156-2.761719-4.777344-8.878906-6.417969-13.660156-3.660157-4.78125 2.761719-6.421875 8.882813-3.660156 13.660157 2.757812 4.78125 8.878906 6.421875 13.660156 3.660156zm0 0"></path>
                                        <path d="m95.984375 377.253906 50.359375 87.230469c10.867188 18.84375 35.3125 25.820313 54.644531 14.644531 19.128907-11.054687 25.703125-35.496094 14.636719-54.640625l-30-51.96875 25.980469-15c4.78125-2.765625 6.421875-8.878906 3.660156-13.660156l-13.003906-22.523437c1.550781-.300782 11.746093-2.300782 191.539062-37.570313 22.226563-1.207031 35.542969-25.515625 24.316407-44.949219l-33.234376-57.5625 21.238282-32.167968c2.085937-3.164063 2.210937-7.230469.316406-10.511719l-20-34.640625c-1.894531-3.28125-5.492188-5.203125-9.261719-4.980469l-38.472656 2.308594-36.894531-63.90625c-5.34375-9.257813-14.917969-14.863281-25.605469-14.996094-.128906-.003906-.253906-.003906-.382813-.003906-10.328124 0-19.703124 5.140625-25.257812 13.832031l-130.632812 166.414062-84.925782 49.03125c-33.402344 19.277344-44.972656 62.128907-25.621094 95.621094 17.679688 30.625 54.953126 42.671875 86.601563 30zm102.324219 57.238282c5.523437 9.554687 2.253906 21.78125-7.328125 27.316406-9.613281 5.558594-21.855469 2.144531-27.316407-7.320313l-50-86.613281 34.640626-20c57.867187 100.242188 49.074218 85.011719 50.003906 86.617188zm-22.683594-79.296876-10-17.320312 17.320312-10 10 17.320312zm196.582031-235.910156 13.820313 23.9375-12.324219 18.664063-23.820313-41.261719zm-104.917969-72.132812c2.683594-4.390625 6.941407-4.84375 8.667969-4.796875 1.707031.019531 5.960938.550781 8.527344 4.996093l116.3125 201.464844c3.789063 6.558594-.816406 14.804688-8.414063 14.992188-1.363281.03125-1.992187.277344-5.484374.929687l-123.035157-213.105469c2.582031-3.320312 2.914063-3.640624 3.425781-4.480468zm-16.734374 21.433594 115.597656 200.222656-174.460938 34.21875-53.046875-91.878906zm-223.851563 268.667968c-4.390625-7.597656-6.710937-16.222656-6.710937-24.949218 0-17.835938 9.585937-34.445313 25.011718-43.351563l77.941406-45 50 86.601563-77.941406 45.003906c-23.878906 13.78125-54.515625 5.570312-68.300781-18.304688zm0 0"></path>
                                        <path d="m105.984375 314.574219c-2.761719-4.78125-8.878906-6.421875-13.660156-3.660157l-17.320313 10c-4.773437 2.757813-10.902344 1.113282-13.660156-3.660156-2.761719-4.78125-8.878906-6.421875-13.660156-3.660156s-6.421875 8.878906-3.660156 13.660156c8.230468 14.257813 26.589843 19.285156 40.980468 10.980469l17.320313-10c4.78125-2.761719 6.421875-8.875 3.660156-13.660156zm0 0"></path>
                                        <path d="m497.136719 43.746094-55.722657 31.007812c-4.824218 2.6875-6.5625 8.777344-3.875 13.601563 2.679688 4.820312 8.765626 6.566406 13.601563 3.875l55.71875-31.007813c4.828125-2.6875 6.5625-8.777344 3.875-13.601562-2.683594-4.828125-8.773437-6.5625-13.597656-3.875zm0 0"></path>
                                        <path d="m491.292969 147.316406-38.636719-10.351562c-5.335938-1.429688-10.820312 1.734375-12.25 7.070312-1.429688 5.335938 1.738281 10.816406 7.074219 12.246094l38.640625 10.351562c5.367187 1.441407 10.824218-1.773437 12.246094-7.070312 1.429687-5.335938-1.738282-10.820312-7.074219-12.246094zm0 0"></path>
                                        <path d="m394.199219 7.414062-10.363281 38.640626c-1.429688 5.335937 1.734374 10.816406 7.070312 12.25 5.332031 1.425781 10.816406-1.730469 12.25-7.070313l10.359375-38.640625c1.429687-5.335938-1.734375-10.820312-7.070313-12.25-5.332031-1.429688-10.816406 1.734375-12.246093 7.070312zm0 0"></path>
                                    </svg>
                                </svg>
                            </span>
                            <span class="title">Marketing Banners</span>
                        </a>
                    </li>
                    <li>
                        <a href="?a=security"><span class="icon">
                                <svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" id="lock2" viewbox="0 0 512 512" width="100%" height="100%">
                                        <path d="M400,188h-36.037v-82.23c0-58.322-48.449-105.77-108-105.77c-59.551,0-108,47.448-108,105.77V188H112 c-33.084,0-60,26.916-60,60v204c0,33.084,26.916,60,60,60h288c33.084,0,60-26.916,60-60V248C460,214.916,433.084,188,400,188z M187.963,105.77c0-36.266,30.505-65.77,68-65.77s68,29.504,68,65.77V188h-136V105.77z M420,452c0,11.028-8.972,20-20,20H112 c-11.028,0-20-8.972-20-20V248c0-11.028,8.972-20,20-20h288c11.028,0,20,8.972,20,20V452z"></path>
                                        <path d="M256,286c-20.435,0-37,16.565-37,37c0,13.048,6.76,24.51,16.963,31.098V398c0,11.045,8.954,20,20,20 c11.045,0,20-8.955,20-20v-43.855C286.207,347.565,293,336.08,293,323C293,302.565,276.435,286,256,286z"></path>
                                    </svg>
                                </svg>
                            </span>
                            <span class="title">Security Authentication</span>
                        </a>
                    </li>
                    <li>
                        <a href="?a=edit_account" class="active"><span class="icon">
                                <svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewbox="0 0 18.86 18.86" id="setting" width="100%" height="100%">
                                        <g clip-path="url(#a)">
                                            <path d="M10.38 2a.56.56 0 0 1 .37.46c.11.48.24 1 .35 1.45a.21.21 0 0 0 .15.17l.71.3h.1a.22.22 0 0 0 .11 0l1.16-.69a.59.59 0 0 1 .3-.1.5.5 0 0 1 .35.18l1.12 1.1a.46.46 0 0 1 .08.66l-.69 1.14a.2.2 0 0 0 0 .21q.16.36.3.72a.2.2 0 0 0 .16.14l1.52.37a.46.46 0 0 1 .4.51v1.59a.46.46 0 0 1-.41.52l-1.52.38a.26.26 0 0 0-.15.13c-.11.23-.2.47-.3.7a.2.2 0 0 0 0 .21l.67 1.12a.46.46 0 0 1-.08.67L14 15a.53.53 0 0 1-.37.19.62.62 0 0 1-.32-.11l-1.09-.66a.22.22 0 0 0-.12 0h-.12l-.73.31a.2.2 0 0 0-.14.16c-.12.51-.25 1-.37 1.52a.46.46 0 0 1-.51.4h-1.6a.46.46 0 0 1-.52-.4c-.12-.51-.25-1-.38-1.52a.27.27 0 0 0-.13-.15l-.73-.31h-.1a.21.21 0 0 0-.11 0l-1.09.66a.61.61 0 0 1-.3.1.51.51 0 0 1-.36-.18L3.8 14a.47.47 0 0 1-.08-.67l.65-1.08a.2.2 0 0 0 0-.21c-.11-.24-.21-.49-.31-.73a.21.21 0 0 0-.17-.15l-1.46-.36a.56.56 0 0 1-.43-.42V8.47a.56.56 0 0 1 .44-.37l1.46-.36a.21.21 0 0 0 .17-.15c.08-.21.16-.41.25-.62a.2.2 0 0 0 0-.21l-.75-1.23a.47.47 0 0 1 .09-.67l1.1-1.1a.52.52 0 0 1 .36-.19.64.64 0 0 1 .32.11l1.18.71a.21.21 0 0 0 .12 0h.11l.74-.32a.22.22 0 0 0 .16-.18c.12-.49.24-1 .36-1.46A.56.56 0 0 1 8.47 2h1.91m.34-2h-2.6L7.8.12a2.54 2.54 0 0 0-1.6 1.7 2.42 2.42 0 0 0-2.86.52l-1.1 1.1a2.45 2.45 0 0 0-.55 2.8A2.53 2.53 0 0 0 .12 7.8L0 8.12v2.61l.12.33a2.54 2.54 0 0 0 1.69 1.59 2.44 2.44 0 0 0 .58 2.72l1.11 1.11a2.43 2.43 0 0 0 2.71.58 2.43 2.43 0 0 0 2.42 1.8h1.6A2.42 2.42 0 0 0 12.65 17a2.43 2.43 0 0 0 2.76-.57l1.1-1.1a2.41 2.41 0 0 0 .57-2.73 2.43 2.43 0 0 0 1.77-2.41v-1.6a2.42 2.42 0 0 0-1.79-2.41 2.43 2.43 0 0 0-.55-2.76l-1.12-1.09a2.42 2.42 0 0 0-2.75-.55A2.54 2.54 0 0 0 11 .11z"></path>
                                            <path d="M9.43 8.21a1.22 1.22 0 0 1 0 2.44 1.22 1.22 0 0 1 0-2.44m0-2a3.22 3.22 0 1 0 3.22 3.23 3.22 3.22 0 0 0-3.22-3.23z"></path>
                                        </g>
                                    </svg>
                                </svg>
                            </span>
                            <span class="title">Settings</span>
                        </a>
                    </li>
                    <li>
                        <a href="?a=logout"><span class="icon">
                                <svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewbox="0 0 15.8 18.2" id="logout" width="100%" height="100%">
                                        <path d="M7.9 18.2c-4.4 0-7.9-3.5-7.9-7.9 0-2.6 1.3-5 3.4-6.5.5-.3 1.1-.2 1.4.2.3.5.2 1.1-.2 1.4C3 6.5 2 8.3 2 10.3c0 3.2 2.6 5.9 5.9 5.9 3.2 0 5.9-2.6 5.9-5.9 0-1.9-.9-3.6-2.4-4.7-.4-.3-.5-1-.2-1.4.3-.4 1-.5 1.4-.2 2 1.5 3.2 3.9 3.2 6.3 0 4.3-3.6 7.9-7.9 7.9z"></path>
                                        <path d="M7.9 8.7c-.6 0-1-.4-1-1V1c0-.6.4-1 1-1s1 .4 1 1v6.7c0 .5-.5 1-1 1z"></path>
                                    </svg>
                                </svg>
                            </span>
                            <span class="title">Logout</span>
                        </a>
                    </li>
                </ul>
            </div>
            <!--
          <div class="fill-profile mt-4 d-none d-md-block">
          <h4 class="title">Please Complete Your Profile </h4>
          <p>
          Your bitcoin address is undefined and you can’t make withdrawal while it’s undefined!
        </p>
      </div>
    -->
        </div>
    </section>
    <!-- end sidebar -->
    <!-- main -->
    <section class="main">
        
						
            <section id="bw-setting">

                {if $frm.say eq 'changed'} <div style="background: #fff!important;" class="alert alert-success"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 12.34 10.43" id="tick">
                        <g clip-path="url(#a)">
                            <path d="M4.28 10.43L0 5.44l1.52-1.3L4.3 7.39 10.84 0l1.5 1.32-8.06 9.11z"></path>
                        </g>
                    </svg> Your account data has been updated successfully.</div>

                {/if}

                {if $errors}

                {section name=e loop=$errors}


                {if $errors[e] eq 'full_name'}
                <div class="alert alert-danger alert-dismissible mb-4" role="alert">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                    <svg>
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 286.05 286.05" id="danger">
                            <path d="M143 0a143 143 0 1 0 143 143A143 143 0 0 0 143 0zm0 259.24A116.21 116.21 0 1 1 259.24 143 116.21 116.21 0 0 1 143 259.24zm0-196.51c-10.24 0-18 5.35-18 14v79.2c0 8.64 7.75 14 18 14 10 0 18-5.55 18-14V76.71c0-8.43-8-13.98-18-13.98zm0 125a17.85 17.85 0 1 0 17.84 17.86A17.88 17.88 0 0 0 143 187.72z"></path>
                        </svg>
                    </svg>
                    Please enter your Full Name!
                </div>


                {/if} {if $errors[e] eq 'address'}

                <div class="alert alert-danger alert-dismissible mb-4" role="alert">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                    <svg>
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 286.05 286.05" id="danger">
                            <path d="M143 0a143 143 0 1 0 143 143A143 143 0 0 0 143 0zm0 259.24A116.21 116.21 0 1 1 259.24 143 116.21 116.21 0 0 1 143 259.24zm0-196.51c-10.24 0-18 5.35-18 14v79.2c0 8.64 7.75 14 18 14 10 0 18-5.55 18-14V76.71c0-8.43-8-13.98-18-13.98zm0 125a17.85 17.85 0 1 0 17.84 17.86A17.88 17.88 0 0 0 143 187.72z"></path>
                        </svg>
                    </svg>
                    Please enter your address!
                </div>

                {/if} {if $errors[e] eq 'city'}

                <div class="alert alert-danger alert-dismissible mb-4" role="alert">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                    <svg>
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 286.05 286.05" id="danger">
                            <path d="M143 0a143 143 0 1 0 143 143A143 143 0 0 0 143 0zm0 259.24A116.21 116.21 0 1 1 259.24 143 116.21 116.21 0 0 1 143 259.24zm0-196.51c-10.24 0-18 5.35-18 14v79.2c0 8.64 7.75 14 18 14 10 0 18-5.55 18-14V76.71c0-8.43-8-13.98-18-13.98zm0 125a17.85 17.85 0 1 0 17.84 17.86A17.88 17.88 0 0 0 143 187.72z"></path>
                        </svg>
                    </svg>
                    Please enter your city!
                </div>

                {/if} {if $errors[e] eq 'state'}

                <div class="alert alert-danger alert-dismissible mb-4" role="alert">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                    <svg>
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 286.05 286.05" id="danger">
                            <path d="M143 0a143 143 0 1 0 143 143A143 143 0 0 0 143 0zm0 259.24A116.21 116.21 0 1 1 259.24 143 116.21 116.21 0 0 1 143 259.24zm0-196.51c-10.24 0-18 5.35-18 14v79.2c0 8.64 7.75 14 18 14 10 0 18-5.55 18-14V76.71c0-8.43-8-13.98-18-13.98zm0 125a17.85 17.85 0 1 0 17.84 17.86A17.88 17.88 0 0 0 143 187.72z"></path>
                        </svg>
                    </svg>
                    Please enter your state!
                </div>

                {/if} {if $errors[e] eq 'zip'}

                <div class="alert alert-danger alert-dismissible mb-4" role="alert">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                    <svg>
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 286.05 286.05" id="danger">
                            <path d="M143 0a143 143 0 1 0 143 143A143 143 0 0 0 143 0zm0 259.24A116.21 116.21 0 1 1 259.24 143 116.21 116.21 0 0 1 143 259.24zm0-196.51c-10.24 0-18 5.35-18 14v79.2c0 8.64 7.75 14 18 14 10 0 18-5.55 18-14V76.71c0-8.43-8-13.98-18-13.98zm0 125a17.85 17.85 0 1 0 17.84 17.86A17.88 17.88 0 0 0 143 187.72z"></path>
                        </svg>
                    </svg>
                    Please enter your zip!
                </div>
                {/if} {if $errors[e] eq 'country'}

                <div class="alert alert-danger alert-dismissible mb-4" role="alert">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                    <svg>
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 286.05 286.05" id="danger">
                            <path d="M143 0a143 143 0 1 0 143 143A143 143 0 0 0 143 0zm0 259.24A116.21 116.21 0 1 1 259.24 143 116.21 116.21 0 0 1 143 259.24zm0-196.51c-10.24 0-18 5.35-18 14v79.2c0 8.64 7.75 14 18 14 10 0 18-5.55 18-14V76.71c0-8.43-8-13.98-18-13.98zm0 125a17.85 17.85 0 1 0 17.84 17.86A17.88 17.88 0 0 0 143 187.72z"></path>
                        </svg>
                    </svg>
                    Please choose your country!
                </div>
                {/if} {if $errors[e] eq 'username'}
                <div class="alert alert-danger alert-dismissible mb-4" role="alert">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                    <svg>
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 286.05 286.05" id="danger">
                            <path d="M143 0a143 143 0 1 0 143 143A143 143 0 0 0 143 0zm0 259.24A116.21 116.21 0 1 1 259.24 143 116.21 116.21 0 0 1 143 259.24zm0-196.51c-10.24 0-18 5.35-18 14v79.2c0 8.64 7.75 14 18 14 10 0 18-5.55 18-14V76.71c0-8.43-8-13.98-18-13.98zm0 125a17.85 17.85 0 1 0 17.84 17.86A17.88 17.88 0 0 0 143 187.72z"></path>
                        </svg>
                    </svg>
                    Please enter your username!
                </div>

                {/if} {if $errors[e] eq 'password'}

                <div class="alert alert-danger alert-dismissible mb-4" role="alert">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                    <svg>
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 286.05 286.05" id="danger">
                            <path d="M143 0a143 143 0 1 0 143 143A143 143 0 0 0 143 0zm0 259.24A116.21 116.21 0 1 1 259.24 143 116.21 116.21 0 0 1 143 259.24zm0-196.51c-10.24 0-18 5.35-18 14v79.2c0 8.64 7.75 14 18 14 10 0 18-5.55 18-14V76.71c0-8.43-8-13.98-18-13.98zm0 125a17.85 17.85 0 1 0 17.84 17.86A17.88 17.88 0 0 0 143 187.72z"></path>
                        </svg>
                    </svg>
                    Please enter a password!
                </div>
                {/if} {if $errors[e] eq 'password_confirm'}
                <div class="alert alert-danger alert-dismissible mb-4" role="alert">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                    <svg>
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 286.05 286.05" id="danger">
                            <path d="M143 0a143 143 0 1 0 143 143A143 143 0 0 0 143 0zm0 259.24A116.21 116.21 0 1 1 259.24 143 116.21 116.21 0 0 1 143 259.24zm0-196.51c-10.24 0-18 5.35-18 14v79.2c0 8.64 7.75 14 18 14 10 0 18-5.55 18-14V76.71c0-8.43-8-13.98-18-13.98zm0 125a17.85 17.85 0 1 0 17.84 17.86A17.88 17.88 0 0 0 143 187.72z"></path>
                        </svg>
                    </svg>
                    Please check your password!
                </div>

                {/if} {if $errors[e] eq 'password_too_small'}
                <div class="alert alert-danger alert-dismissible mb-4" role="alert">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                    <svg>
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 286.05 286.05" id="danger">
                            <path d="M143 0a143 143 0 1 0 143 143A143 143 0 0 0 143 0zm0 259.24A116.21 116.21 0 1 1 259.24 143 116.21 116.21 0 0 1 143 259.24zm0-196.51c-10.24 0-18 5.35-18 14v79.2c0 8.64 7.75 14 18 14 10 0 18-5.55 18-14V76.71c0-8.43-8-13.98-18-13.98zm0 125a17.85 17.85 0 1 0 17.84 17.86A17.88 17.88 0 0 0 143 187.72z"></path>
                        </svg>
                    </svg>
                    Password is too small, please enter at least {$settings.min_user_password_length} chars!
                </div>

                {/if} {if $errors[e] eq 'transaction_code'}
                <div class="alert alert-danger alert-dismissible mb-4" role="alert">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                    <svg>
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 286.05 286.05" id="danger">
                            <path d="M143 0a143 143 0 1 0 143 143A143 143 0 0 0 143 0zm0 259.24A116.21 116.21 0 1 1 259.24 143 116.21 116.21 0 0 1 143 259.24zm0-196.51c-10.24 0-18 5.35-18 14v79.2c0 8.64 7.75 14 18 14 10 0 18-5.55 18-14V76.71c0-8.43-8-13.98-18-13.98zm0 125a17.85 17.85 0 1 0 17.84 17.86A17.88 17.88 0 0 0 143 187.72z"></path>
                        </svg>
                    </svg>
                    Please enter the Transaction Code!
                </div>


                {/if} {if $errors[e] eq 'transaction_code_confirm'}
                <div class="alert alert-danger alert-dismissible mb-4" role="alert">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                    <svg>
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 286.05 286.05" id="danger">
                            <path d="M143 0a143 143 0 1 0 143 143A143 143 0 0 0 143 0zm0 259.24A116.21 116.21 0 1 1 259.24 143 116.21 116.21 0 0 1 143 259.24zm0-196.51c-10.24 0-18 5.35-18 14v79.2c0 8.64 7.75 14 18 14 10 0 18-5.55 18-14V76.71c0-8.43-8-13.98-18-13.98zm0 125a17.85 17.85 0 1 0 17.84 17.86A17.88 17.88 0 0 0 143 187.72z"></path>
                        </svg>
                    </svg>
                    Please check your Transaction Code!
                </div>


                {/if} {if $errors[e] eq 'transaction_code_too_small'}
                <div class="alert alert-danger alert-dismissible mb-4" role="alert">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                    <svg>
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 286.05 286.05" id="danger">
                            <path d="M143 0a143 143 0 1 0 143 143A143 143 0 0 0 143 0zm0 259.24A116.21 116.21 0 1 1 259.24 143 116.21 116.21 0 0 1 143 259.24zm0-196.51c-10.24 0-18 5.35-18 14v79.2c0 8.64 7.75 14 18 14 10 0 18-5.55 18-14V76.71c0-8.43-8-13.98-18-13.98zm0 125a17.85 17.85 0 1 0 17.84 17.86A17.88 17.88 0 0 0 143 187.72z"></path>
                        </svg>
                    </svg>
                    Transaction Code is too small, please enter at least {$settings.min_user_password_length} chars!
                </div>

                {/if} {if $errors[e] eq 'wrong_current_password'}
                <div class="alert alert-danger alert-dismissible mb-4" role="alert">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                    <svg>
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 286.05 286.05" id="danger">
                            <path d="M143 0a143 143 0 1 0 143 143A143 143 0 0 0 143 0zm0 259.24A116.21 116.21 0 1 1 259.24 143 116.21 116.21 0 0 1 143 259.24zm0-196.51c-10.24 0-18 5.35-18 14v79.2c0 8.64 7.75 14 18 14 10 0 18-5.55 18-14V76.71c0-8.43-8-13.98-18-13.98zm0 125a17.85 17.85 0 1 0 17.84 17.86A17.88 17.88 0 0 0 143 187.72z"></path>
                        </svg>
                    </svg>
                    You entered wrong current password
                </div>


                {/if} {if $errors[e] eq 'transaction_code_vs_password'}
                <div class="alert alert-danger alert-dismissible mb-4" role="alert">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                    <svg>
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 286.05 286.05" id="danger">
                            <path d="M143 0a143 143 0 1 0 143 143A143 143 0 0 0 143 0zm0 259.24A116.21 116.21 0 1 1 259.24 143 116.21 116.21 0 0 1 143 259.24zm0-196.51c-10.24 0-18 5.35-18 14v79.2c0 8.64 7.75 14 18 14 10 0 18-5.55 18-14V76.71c0-8.43-8-13.98-18-13.98zm0 125a17.85 17.85 0 1 0 17.84 17.86A17.88 17.88 0 0 0 143 187.72z"></path>
                        </svg>
                    </svg>
                    Transaction Code should be different then the Password!
                </div>

                {/if} {if $errors[e] eq 'invalid_transaction_code'}
                <div class="alert alert-danger alert-dismissible mb-4" role="alert">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                    <svg>
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 286.05 286.05" id="danger">
                            <path d="M143 0a143 143 0 1 0 143 143A143 143 0 0 0 143 0zm0 259.24A116.21 116.21 0 1 1 259.24 143 116.21 116.21 0 0 1 143 259.24zm0-196.51c-10.24 0-18 5.35-18 14v79.2c0 8.64 7.75 14 18 14 10 0 18-5.55 18-14V76.71c0-8.43-8-13.98-18-13.98zm0 125a17.85 17.85 0 1 0 17.84 17.86A17.88 17.88 0 0 0 143 187.72z"></path>
                        </svg>
                    </svg>
                    You have provided invalid Current Transaction Code!
                </div>


                {/if} {if $errors[e] eq 'email'}

                <div class="alert alert-danger alert-dismissible mb-4" role="alert">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                    <svg>
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 286.05 286.05" id="danger">
                            <path d="M143 0a143 143 0 1 0 143 143A143 143 0 0 0 143 0zm0 259.24A116.21 116.21 0 1 1 259.24 143 116.21 116.21 0 0 1 143 259.24zm0-196.51c-10.24 0-18 5.35-18 14v79.2c0 8.64 7.75 14 18 14 10 0 18-5.55 18-14V76.71c0-8.43-8-13.98-18-13.98zm0 125a17.85 17.85 0 1 0 17.84 17.86A17.88 17.88 0 0 0 143 187.72z"></path>
                        </svg>
                    </svg>
                    Please enter your e-mail!
                </div>

                {/if} {if $errors[e] eq 'turing_image'}
                <div class="alert alert-danger alert-dismissible mb-4" role="alert">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                    <svg>
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 286.05 286.05" id="danger">
                            <path d="M143 0a143 143 0 1 0 143 143A143 143 0 0 0 143 0zm0 259.24A116.21 116.21 0 1 1 259.24 143 116.21 116.21 0 0 1 143 259.24zm0-196.51c-10.24 0-18 5.35-18 14v79.2c0 8.64 7.75 14 18 14 10 0 18-5.55 18-14V76.71c0-8.43-8-13.98-18-13.98zm0 125a17.85 17.85 0 1 0 17.84 17.86A17.88 17.88 0 0 0 143 187.72z"></path>
                        </svg>
                    </svg>
                    Enter the verification code as it is shown in the corresponding box.
                </div>
                {/if} {if $errors[e] eq 'tfa_code'}

                <div class="alert alert-danger alert-dismissible mb-4" role="alert">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                    <svg>
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 286.05 286.05" id="danger">
                            <path d="M143 0a143 143 0 1 0 143 143A143 143 0 0 0 143 0zm0 259.24A116.21 116.21 0 1 1 259.24 143 116.21 116.21 0 0 1 143 259.24zm0-196.51c-10.24 0-18 5.35-18 14v79.2c0 8.64 7.75 14 18 14 10 0 18-5.55 18-14V76.71c0-8.43-8-13.98-18-13.98zm0 125a17.85 17.85 0 1 0 17.84 17.86A17.88 17.88 0 0 0 143 187.72z"></path>
                        </svg>
                    </svg>
                    Invalid 2FA code
                </div>


                {/if} {if $errors[e] eq 'invalid_account_format'} {foreach from=$account_errors item=err}

                <div class="alert alert-danger alert-dismissible mb-4" role="alert">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                    <svg>
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 286.05 286.05" id="danger">
                            <path d="M143 0a143 143 0 1 0 143 143A143 143 0 0 0 143 0zm0 259.24A116.21 116.21 0 1 1 259.24 143 116.21 116.21 0 0 1 143 259.24zm0-196.51c-10.24 0-18 5.35-18 14v79.2c0 8.64 7.75 14 18 14 10 0 18-5.55 18-14V76.71c0-8.43-8-13.98-18-13.98zm0 125a17.85 17.85 0 1 0 17.84 17.86A17.88 17.88 0 0 0 143 187.72z"></path>
                        </svg>
                    </svg>
                    {$err}
                </div>


                {/foreach} {/if}
                {/section}

                {/if}

                <div class="card card-body _bg_b " style="width: 100%">
                    <h1 class="page-title">
                        <svg>
                            <svg xmlns="http://www.w3.org/2000/svg" viewbox="0 0 18.86 18.86" id="setting" width="100%" height="100%">
                                <g clip-path="url(#a)">
                                    <path d="M10.38 2a.56.56 0 0 1 .37.46c.11.48.24 1 .35 1.45a.21.21 0 0 0 .15.17l.71.3h.1a.22.22 0 0 0 .11 0l1.16-.69a.59.59 0 0 1 .3-.1.5.5 0 0 1 .35.18l1.12 1.1a.46.46 0 0 1 .08.66l-.69 1.14a.2.2 0 0 0 0 .21q.16.36.3.72a.2.2 0 0 0 .16.14l1.52.37a.46.46 0 0 1 .4.51v1.59a.46.46 0 0 1-.41.52l-1.52.38a.26.26 0 0 0-.15.13c-.11.23-.2.47-.3.7a.2.2 0 0 0 0 .21l.67 1.12a.46.46 0 0 1-.08.67L14 15a.53.53 0 0 1-.37.19.62.62 0 0 1-.32-.11l-1.09-.66a.22.22 0 0 0-.12 0h-.12l-.73.31a.2.2 0 0 0-.14.16c-.12.51-.25 1-.37 1.52a.46.46 0 0 1-.51.4h-1.6a.46.46 0 0 1-.52-.4c-.12-.51-.25-1-.38-1.52a.27.27 0 0 0-.13-.15l-.73-.31h-.1a.21.21 0 0 0-.11 0l-1.09.66a.61.61 0 0 1-.3.1.51.51 0 0 1-.36-.18L3.8 14a.47.47 0 0 1-.08-.67l.65-1.08a.2.2 0 0 0 0-.21c-.11-.24-.21-.49-.31-.73a.21.21 0 0 0-.17-.15l-1.46-.36a.56.56 0 0 1-.43-.42V8.47a.56.56 0 0 1 .44-.37l1.46-.36a.21.21 0 0 0 .17-.15c.08-.21.16-.41.25-.62a.2.2 0 0 0 0-.21l-.75-1.23a.47.47 0 0 1 .09-.67l1.1-1.1a.52.52 0 0 1 .36-.19.64.64 0 0 1 .32.11l1.18.71a.21.21 0 0 0 .12 0h.11l.74-.32a.22.22 0 0 0 .16-.18c.12-.49.24-1 .36-1.46A.56.56 0 0 1 8.47 2h1.91m.34-2h-2.6L7.8.12a2.54 2.54 0 0 0-1.6 1.7 2.42 2.42 0 0 0-2.86.52l-1.1 1.1a2.45 2.45 0 0 0-.55 2.8A2.53 2.53 0 0 0 .12 7.8L0 8.12v2.61l.12.33a2.54 2.54 0 0 0 1.69 1.59 2.44 2.44 0 0 0 .58 2.72l1.11 1.11a2.43 2.43 0 0 0 2.71.58 2.43 2.43 0 0 0 2.42 1.8h1.6A2.42 2.42 0 0 0 12.65 17a2.43 2.43 0 0 0 2.76-.57l1.1-1.1a2.41 2.41 0 0 0 .57-2.73 2.43 2.43 0 0 0 1.77-2.41v-1.6a2.42 2.42 0 0 0-1.79-2.41 2.43 2.43 0 0 0-.55-2.76l-1.12-1.09a2.42 2.42 0 0 0-2.75-.55A2.54 2.54 0 0 0 11 .11z"></path>
                                    <path d="M9.43 8.21a1.22 1.22 0 0 1 0 2.44 1.22 1.22 0 0 1 0-2.44m0-2a3.22 3.22 0 1 0 3.22 3.23 3.22 3.22 0 0 0-3.22-3.23z"></path>
                                </g>
                            </svg>
                        </svg>
                        <span>Account Settings</span>
                    </h1>
                    {literal}
                    <script language=javascript>
                        function IsNumeric(sText) {
                            var ValidChars = "0123456789.";
                            var IsNumber = true;
                            var Char;
                            if (sText == '') return false;
                            for (i = 0; i < sText.length && IsNumber == true; i++) {
                                Char = sText.charAt(i);
                                if (ValidChars.indexOf(Char) == -1) {
                                    IsNumber = false;
                                }
                            }
                            return IsNumber;
                        }

                        function checkform() {
                            if (document.editform.fullname.value == '') {
                                alert("Please type your full name!");
                                document.editform.fullname.focus();
                                return false;
                            } {
                                /literal} {
                                if $settings.use_user_location == 1
                            } {
                                literal
                            }
                            if (document.editform.address.value == '') {
                                alert("Please enter your address!");
                                document.editform.address.focus();
                                return false;
                            }
                            if (document.editform.city.value == '') {
                                alert("Please enter your city!");
                                document.editform.city.focus();
                                return false;
                            }
                            if (document.editform.state.value == '') {
                                alert("Please enter your state!");
                                document.editform.state.focus();
                                return false;
                            }
                            if (document.editform.zip.value == '') {
                                alert("Please enter your ZIP!");
                                document.editform.zip.focus();
                                return false;
                            }
                            if (document.editform.country.options[document.editform.country.selectedIndex].text == '--SELECT--') {
                                alert("Please choose your country!");
                                document.editform.country.focus();
                                return false;
                            } {
                                /literal} { /
                                if
                            } {
                                literal
                            }
                            if (document.editform.password.value != document.editform.password2.value) {
                                alert("Please check your password!");
                                document.editform.fullname.focus();
                                return false;
                            } {
                                /literal} {
                                if $settings.use_transaction_code
                            } {
                                literal
                            }
                            if (document.editform.transaction_code.value != document.editform.transaction_code2.value) {
                                alert("Please check your transaction code!");
                                document.editform.transaction_code2.focus();
                                return false;
                            } {
                                /literal} { /
                                if
                            } {
                                literal
                            } {
                                /literal} {
                                if $settings.usercanchangeemail == 1
                            } {
                                literal
                            }
                            if (document.editform.email.value == '') {
                                alert("Please enter your e-mail address!");
                                document.editform.email.focus();
                                return false;
                            } {
                                /literal} { /
                                if
                            } {
                                literal
                            }
                            for (i in document.editform.elements) {
                                f = document.editform.elements[i];
                                if (f.name && f.name.match(/^pay_account/)) {
                                    if (f.value == '') continue;
                                    var notice = f.getAttribute('data-validate-notice');
                                    var invalid = 0;
                                    if (f.getAttribute('data-validate') == 'regexp') {
                                        var re = new RegExp(f.getAttribute('data-validate-regexp'));
                                        if (!f.value.match(re)) {
                                            invalid = 1;
                                        }
                                    } else if (f.getAttribute('data-validate') == 'email') {
                                        var re = /^[^\@]+\@[^\@]+\.\w{2,4}$/;
                                        if (!f.value.match(re)) {
                                            invalid = 1;
                                        }
                                    }
                                    if (invalid) {
                                        alert('Invalid account format. Expected ' + notice);
                                        f.focus();
                                        return false;
                                    }
                                }
                            }
                            return true;
                        }

                    </script>
                    {/literal}
                    <form action="" method=post onsubmit="return checkform()" name=editform>
                        <input type=hidden name=a value=edit_account>
                        <input type=hidden name=action value=edit_account>
                        <input type=hidden name=say value="">
                        <br>


                        <div class="form-group mt-4">
                            <label>Your Full Name</label>
                            <input type=text name=fullname value='{$userinfo.name|escape:"quotes"}' class='form-control'>
                        </div>


                        {if $settings.use_user_location}

                        <div class="form-group mt-4">
                            <label>Your Address</label>
                            <input type=text name=address value="{$userinfo.address|escape:" quotes"}" class='form-control'>
                        </div>


                        <div class="form-group mt-4">
                            <label>Your City</label>
                            <input type=text name=city value="{$userinfo.city|escape:" quotes"}" class='form-control'>
                        </div>


                        <div class="form-group mt-4">
                            <label>Your State</label>
                            <input type=text name=state value="{$userinfo.state|escape:" quotes"}" class='form-control'>
                        </div>


                        <div class="form-group mt-4">
                            <label>Your Zip</label>
                            <input type=text name=zip value="{$userinfo.zip|escape:" quotes"}" class='form-control'>
                        </div>


                        <div class="form-group mt-4">
                            <label>Your Country</label>
                            <select name='country' class='form-control' class=inpts>
                                <option value=''>--SELECT--</option>
                                {section name=c loop=$countries}
                                <option {if $countries[c].name eq $userinfo.country}selected{/if}>{$countries[c].name|escape:"quotes"} </option> {/section} </select> </div> {/if} <div class="form-group">
                                    <label>Change Your Password</label>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <input name="password" placeholder="Type password" type="password" class="form-control mb-2">
                                        </div>
                                        <div class="col-md-6">
                                            <input name="password2" placeholder="Retype password" type="password" class="form-control">
                                        </div>
                                    </div>
                        </div>
                        {if $settings.use_transaction_code} {if $settings.use_transaction_code_edit_account != 1} {if $userinfo.transaction_code != ''}


                        <div class="form-group">
                            <label>Current Transaction Code</label>
                            <input type=password name=transaction_code_current class='form-control' value="">
                        </div>


                        {/if} {/if}

                        <div class="form-group">
                            <label>New Transaction Code</label>
                            <div class="row">
                                <div class="col-md-6">
                                    <input placeholder="New Transaction Code" type=password name=transaction_code value="" class="form-control mb-2">
                                </div>
                                <div class="col-md-6">
                                    <input placeholder="Retype Transaction Code" type=password name=transaction_code2 value="" class="form-control">
                                </div>
                            </div>
                        </div>



                        {/if} {foreach item=ps from=$pay_accounts}
                        <div class="form-group">
                            <label>Set Your {$ps.name} Account</label>
                            {if $settings.usercanchangeegoldacc == 0 && $ps.account != ''}
							<input readonly disabled="disabled" readonly="readonly" placeholder="{$ps.account|escape:html}" type=text class='form-control'>
							{else}<input placeholder="Type your account" type=text name="pay_account[{$ps.id}]" class='form-control' value="{$frm.pay_account[$ps.id]|default:$ps.account|escape:html}" data-validate="{$ps.validate.func}" data-validate-{$ps.validate.func}="{$ps.validate[$ps.validate.func]}" data-validate-notice="{$ps.validate.notification|escape:html}">{/if}
                        </div>
                        {/foreach} {foreach item=p from=$mpay_accounts} {foreach item=ps from=$p.accounts}
                        <div class="form-group">
                            <label>Your {$p.name} {$ps.name}</label>
                            {if $settings.usercanchangeegoldacc == 0 && $ps.value != ''}
							<input readonly disabled="disabled" readonly="readonly" placeholder="{$ps.value|escape:html}" type=text class='form-control'>
							{else}<input placeholder="Type your account" type=text class='form-control' name="pay_account[{$p.id}][{$ps.name|escape:html}]" value="{$frm.pay_account[$p.id][$ps.name]|default:$ps.value|escape:html}">{/if}
                        </div>
                        {/foreach} {/foreach}
                        <div class="form-group">
                            <label>Your E-mail Address</label>
                            {if $settings.usercanchangeemail == 1}<input type=text name=email class='form-control' value='{$userinfo.email|escape:"quotes"}'>{else}{$userinfo.email}{/if}
                        </div>
                        {if $userinfo.admin_auto_pay_earning == 1}

                        <div class="form-group">
                            <label>Receive earnings directly to e-currency account</label>
                            <input type=checkbox name=user_auto_pay_earning value=1 {if $userinfo.user_auto_pay_earning==1}checked{/if}> </div> {/if} {if $settings.use_transaction_code_edit_account==1} <div class="form-group">
                            <label>Current Transaction Code</label>
                            <input type=password name=transaction_code_current value="" class='form-control'>
                        </div>
                        {/if} {if $userinfo.tfa_settings.edit_account}

                        <div class="form-group">
                            <label>2FA Code</label>
                            <input class='form-control' type="text" name="tfa_code"><input type="hidden" name="tfa_time" id="tfa_time">
                        </div>
                        {literal}
                        <script language=javascript>
                            document.getElementById('tfa_time').value = (new Date()).getTime();

                        </script>
                        {/literal} {/if} {if $ti.check.edit_account}
                        <div class="form-group">
                            <label>Enter Code <img src="?a=show_validation_image&{$ti.session.name}={$ti.session.id}&rand={$ti.session.rand}"></label>
                            <input type=text name=validation_number class='form-control'>
                        </div>
                        {/if}
                        <div class="text-center">
                            <button class="btn btn-bw submit mt-5" type="submit">Update Settings</button>
                        </div>

                    </form>
            </section>
            {include file="mfooter.tpl"}
